var reg_nome_cognome = /^[a-zA-ZàèéìòùÀÈÉÌÒÙ\-_ ’'‘ÆÐƎƏƐƔĲŊŒẞÞǷȜæðǝəɛɣĳŋœĸſßþƿȝĄƁÇĐƊĘĦĮƘŁØƠŞȘŢȚŦŲƯY̨Ƴąɓçđɗęħįƙłøơşșţțŧųưy̨ƴÁÀÂÄǍĂĀÃÅǺĄÆǼǢƁĆĊĈČÇĎḌĐƊÐÉÈĖÊËĚĔĒĘẸƎƏƐĠĜǦĞĢƔáàâäǎăāãåǻąæǽǣɓćċĉčçďḍđɗðéèėêëěĕēęẹǝəɛġĝǧğģɣĤḤĦIÍÌİÎÏǏĬĪĨĮỊĲĴĶƘĹĻŁĽĿʼNŃN̈ŇÑŅŊÓÒÔÖǑŎŌÕŐỌØǾƠŒĥḥħıíìiîïǐĭīĩįịĳĵķƙĸĺļłľŀŉńn̈ňñņŋóòôöǒŏōõőọøǿơœŔŘŖŚŜŠŞȘṢẞŤŢṬŦÞÚÙÛÜǓŬŪŨŰŮŲỤƯẂẀŴẄǷÝỲŶŸȲỸƳŹŻŽẒŕřŗſśŝšşșṣßťţṭŧþúùûüǔŭūũűůųụưẃẁŵẅƿýỳŷÿȳỹƴźżžẓ]*$/;
var reg_luogo_nascita_residenza = /^[A-Za-zàèéìòùÀÈÉÌÒÙ\s\-']{2,}$/;
var reg_indirizzo = /^[A-Za-z0-9àèéìòùÀÈÉÌÒÙ\s\-\.,']{3,}$/;
var reg_iscrizione_ordine = /^[A-Z]{2}\d{1,6}$/;
var reg_civico = /^\d+(\/[a-zA-Z])?$/;
function valida_mail(email) {
    var email_reg =
      /^[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,6}$/;
    return email_reg.test(email);
}
/*==== VALIDAZIONI SEZIONE TECNICO COMPETENTE ====*/

$(document).on("change", "input[name='tipo_tecnico']", function () {
  var tipo_tecnico = $(this).val();
  if (tipo_tecnico == "Tecnico Esterno") {
    $('#nome-tecnico').val("");
    $('#nome-tecnico').removeClass("is-invalid");
    $('#cognome-tecnico').val("");
    $('#cognome-tecnico').removeClass("is-invalid");
    $('#recapito-tecnico').val("");
    $('#recapito-tecnico').removeClass("is-invalid");
    $('#mail-tecnico').val("");
    $('#mail-tecnico').removeClass("is-invalid");
    $('#pec-tecnico').val("");
    $('#pec-tecnico').removeClass("is-invalid");
    $('#tipologia_incarico_div').addClass("d-none");
    $('#dati_tecnico_esterno_1').removeClass("d-none");
    $('#dati_tecnico_esterno_2').removeClass("d-none");
  } else if (tipo_tecnico == "Tecnico Interno") {
    $('#nome-tecnico').val("");
    $('#nome-tecnico').removeClass("is-invalid");
    $('#cognome-tecnico').val("");
    $('#cognome-tecnico').removeClass("is-invalid");
    $('#recapito-tecnico').val("");
    $('#recapito-tecnico').removeClass("is-invalid");
    $('#mail-tecnico').val("");
    $('#mail-tecnico').removeClass("is-invalid");
    $('#pec-tecnico').val("");
    $('#pec-tecnico').removeClass("is-invalid");
    $('#tipologia_incarico_div').removeClass("d-none");
    $('#dati_tecnico_esterno_1').addClass("d-none");
    $('#dati_tecnico_esterno_2').addClass("d-none");
  }
});

$(document).on("input", "#nome-tecnico", function () {
    var nomeTecnico = $(this).val();
    if (nomeTecnico.length == 0) {
        $("#nome-tecnico").addClass("is-invalid");
        $("#errore_nome_tecnico").addClass("invalid-feedback");
        $("#errore_nome_tecnico").text("Nome del tecnico incaricato obbligatorio.");
    } else if (nomeTecnico.length < 2) {
        $("#nome-tecnico").addClass("is-invalid");
        $("#errore_nome_tecnico").addClass("invalid-feedback");
        $("#errore_nome_tecnico").text("Il nome deve avere almeno due caratteri.");
    } else {
        if (!reg_nome_cognome.test(nomeTecnico)) {
          $("#nome-tecnico").addClass("is-invalid");
          $("#errore_nome_tecnico").addClass("invalid-feedback");
          $("#errore_nome_tecnico").text("Hai inserito caratteri non consentiti.");
        } else {
          $("#nome-tecnico").removeClass("is-invalid");
          $("#errore_nome_tecnico").removeClass("invalid-feedback");
          $("#errore_nome_tecnico").text("");
        }
    }
});
  
$(document).on("input", "#cognome-tecnico", function () {
    var cognomeTecnico = $(this).val();
    if (cognomeTecnico.length == 0) {
        $("#cognome-tecnico").addClass("is-invalid");
        $("#errore_cognome_tecnico").addClass("invalid-feedback");
        $("#errore_cognome_tecnico").text("Cognome del tecnico incaricato obbligatorio.");
    } else if (cognomeTecnico.length < 2) {
        $("#cognome-tecnico").addClass("is-invalid");
        $("#errore_cognome_tecnico").addClass("invalid-feedback");
        $("#errore_cognome_tecnico").text("Il cognome deve avere almeno due caratteri.");
    } else {
        if (!reg_nome_cognome.test(cognomeTecnico)) {
          $("#cognome-tecnico").addClass("is-invalid");
          $("#errore_cognome_tecnico").addClass("invalid-feedback");
          $("#errore_cognome_tecnico").text("Hai inserito caratteri non consentiti.");
        } else {
          $("#cognome-tecnico").removeClass("is-invalid");
          $("#errore_cognome_tecnico").removeClass("invalid-feedback");
          $("#errore_cognome_tecnico").text("");
        }
    }
});

$(document).on("input", "#tipologia_incarico", function () {
  var tipologiaIncarico = $(this).val();
  if (tipologiaIncarico.length == 0) {
      $("#tipologia_incarico").addClass("is-invalid");
      $("#errore_tipologia_incarico").addClass("invalid-feedback");
      $("#errore_tipologia_incarico").text("Tipologia incarico/ruolo obbligatoria.");
  } else if (tipologiaIncarico.length < 2) {
      $("#tipologia_incarico").addClass("is-invalid");
      $("#errore_tipologia_incarico").addClass("invalid-feedback");
      $("#errore_tipologia_incarico").text("Inserire almeno due caratteri.");
  } else {
      if (!reg_nome_cognome.test(tipologiaIncarico)) {
        $("#tipologia_incarico").addClass("is-invalid");
        $("#errore_tipologia_incarico").addClass("invalid-feedback");
        $("#errore_tipologia_incarico").text("Hai inserito caratteri non consentiti.");
      } else {
        $("#tipologia_incarico").removeClass("is-invalid");
        $("#errore_tipologia_incarico").removeClass("invalid-feedback");
        $("#errore_tipologia_incarico").text("");
      }
  }
});
  
$(document).on("input", "#comune-studio-professionale", function () {
    var comuneStudioProfessionale = $(this).val();
    if (comuneStudioProfessionale.length == 0) {
        $("#comune-studio-professionale").addClass("is-invalid");
        $("#errore_comune_studio_professionale").addClass("invalid-feedback");
        $("#errore_comune_studio_professionale").text("Comune studio professionale obbligatorio.");
    } else if (!reg_luogo_nascita_residenza.test(comuneStudioProfessionale)) {
        $("#comune-studio-professionale").addClass("is-invalid");
        $("#errore_comune_studio_professionale").addClass("invalid-feedback");
        $("#errore_comune_studio_professionale").text("Comune studio professionale non valido.");
    } else {
        $("#comune-studio-professionale").removeClass("is-invalid");
        $("#errore_comune_studio_professionale").removeClass("invalid-feedback");
        $("#errore_comune_studio_professionale").text("");
    }
});
  
$(document).on("input", "#provincia-studio-professionale", function () {
    var provinciaStudioProfessionale = $(this).val();
    if (provinciaStudioProfessionale.length == 0) {
        $("#provincia-studio-professionale").addClass("is-invalid");
        $("#errore_provincia_studio_professionale").addClass("invalid-feedback");
        $("#errore_provincia_studio_professionale").text("Provincia studio professionale obbligatoria.");
    } else if (!reg_luogo_nascita_residenza.test(provinciaStudioProfessionale)) {
        $("#provincia-studio-professionale").addClass("is-invalid");
        $("#errore_provincia_studio_professionale").addClass("invalid-feedback");
        $("#errore_provincia_studio_professionale").text("Provincia studio professionale non valida.");
    } else {
        $("#provincia-studio-professionale").removeClass("is-invalid");
        $("#errore_provincia_studio_professionale").removeClass("invalid-feedback");
        $("#errore_provincia_studio_professionale").text("");
    }
});
  
$(document).on("input", "#indirizzo-studio-professionale", function () {
    var indirizzoStudioProfessionale = $(this).val();
    if (indirizzoStudioProfessionale.length == 0) {
        $("#indirizzo-studio-professionale").addClass("is-invalid");
        $("#errore_indirizzo_studio_professionale").addClass("invalid-feedback");
        $("#errore_indirizzo_studio_professionale").text("Indirizzo studio professionale obbligatorio.");
    } else if (!reg_indirizzo.test(indirizzoStudioProfessionale)) {
        $("#indirizzo-studio-professionale").addClass("is-invalid");
        $("#errore_indirizzo_studio_professionale").addClass("invalid-feedback");
        $("#errore_indirizzo_studio_professionale").text("Indirizzo studio professionale non valido.");
    }else {
        $("#indirizzo-studio-professionale").removeClass("is-invalid");
        $("#errore_indirizzo_studio_professionale").removeClass("invalid-feedback");
        $("#errore_indirizzo_studio_professionale").text("");
    }
});

$(document).on("input", "#civico-studio-professionale", function () {
  var civico = $(this).val();
  if (civico.length == 0) {
      $("#civico-studio-professionale").addClass("is-invalid");
      $("#errore_civico_studio_professionale").addClass("invalid-feedback");
      $("#errore_civico_studio_professionale").text("Numero civico obbligatorio.");
  } else {
      $("#civico-studio-professionale").removeClass("is-invalid");
      $("#errore_civico_studio_professionale").removeClass("invalid-feedback");
      $("#errore_civico_studio_professionale").text("");
  }
});
  
$(document).on("input", "#recapito-tecnico", function () {
    var recapitoTecnico = $(this).val().trim();
    if (recapitoTecnico.length === 0) {
        $("#recapito-tecnico").addClass("is-invalid");
        $("#errore_recapito_tecnico").addClass("invalid-feedback");
        $("#errore_recapito_tecnico").text("Recapito tecnico obbligatorio.");
    } 
    else if (!/^\+?\d+$/.test(recapitoTecnico)) {
        $("#recapito-tecnico").addClass("is-invalid");
        $("#errore_recapito_tecnico").addClass("invalid-feedback");
        $("#errore_recapito_tecnico").text("Inserire solo numeri.");
    } 
    else {
        $("#recapito-tecnico").removeClass("is-invalid");
        $("#errore_recapito_tecnico").removeClass("invalid-feedback");
        $("#errore_recapito_tecnico").text("");
    }
});
  
$(document).on("input", "#pec-tecnico", function () {
    var pecTecnico = $(this).val();
    if (pecTecnico.length == 0) {
        $("#pec-tecnico").addClass("is-invalid");
        $("#errore_pec_tecnico").addClass("invalid-feedback");
        $("#errore_pec_tecnico").text("Indirizzo PEC obbligatorio.");
    } else {
      if(pecTecnico.includes("@")){
        var pec_check = pecTecnico.split("@");
        if(pec_check[1].length == 0){
          $("#pec-tecnico").addClass("is-invalid");
          $("#errore_pec_tecnico").addClass("invalid-feedback");
          $("#errore_pec_tecnico").text("Formato PEC errato.");
        }
        else{
          if (!valida_mail(pecTecnico)) {
            $("#pec-tecnico").addClass("is-invalid");
            $("#errore_pec_tecnico").addClass("invalid-feedback");
            $("#errore_pec_tecnico").text("Formato PEC errato.");
          } else {
            $("#pec-tecnico").removeClass("is-invalid");
            $("#errore_pec_tecnico").removeClass("invalid-feedback");
            $("#errore_pec_tecnico").text("");
          }
        }
      }else{
        if (!valida_mail(pecTecnico)) {
          $("#pec-tecnico").addClass("is-invalid");
          $("#errore_pec_tecnico").addClass("invalid-feedback");
          $("#errore_pec_tecnico").text("Formato PEC errato.");
        } else {
          $("#pec-tecnico").removeClass("is-invalid");
          $("#errore_pec_tecnico").removeClass("invalid-feedback");
          $("#errore_pec_tecnico").text("");
        }
      }
    }
});
  
$(document).on("input", "#mail-tecnico", function () {
    var mailTecnico = $(this).val();
    if (mailTecnico.length == 0) {
        $("#mail-tecnico").addClass("is-invalid");
        $("#errore_mail_tecnico").addClass("invalid-feedback");
        $("#errore_mail_tecnico").text("Indirizzo mail obbligatorio.");
    } else {
      if(mailTecnico.includes("@")){
        var pec_check = mailTecnico.split("@");
        if(pec_check[1].length == 0){
          $("#mail-tecnico").addClass("is-invalid");
          $("#errore_mail_tecnico").addClass("invalid-feedback");
          $("#errore_mail_tecnico").text("Formato mail errato.");
        }
        else{
          if (!valida_mail(mailTecnico)) {
            $("#mail-tecnico").addClass("is-invalid");
            $("#errore_mail_tecnico").addClass("invalid-feedback");
            $("#errore_mail_tecnico").text("Formato mail errato.");
          } else {
            $("#mail-tecnico").removeClass("is-invalid");
            $("#errore_mail_tecnico").removeClass("invalid-feedback");
            $("#errore_mail_tecnico").text("");
          }
        }
      }else{
        if (!valida_mail(mailTecnico)) {
          $("#mail-tecnico").addClass("is-invalid");
          $("#errore_mail_tecnico").addClass("invalid-feedback");
          $("#errore_mail_tecnico").text("Formato mail errato.");
        } else {
          $("#mail-tecnico").removeClass("is-invalid");
          $("#errore_mail_tecnico").removeClass("invalid-feedback");
          $("#errore_mail_tecnico").text("");
        }
      }
    }
});
  
$(document).on("input", "#provincia-ordine-tecnico", function () {
    var provinciaTecnico = $(this).val();
    if (provinciaTecnico.length == 0) {
        $("#provincia-ordine-tecnico").addClass("is-invalid");
        $("#errore_provincia_ordine_tecnico").addClass("invalid-feedback");
        $("#errore_provincia_ordine_tecnico").text("Provincia/Sezione/Regione di iscrizione obbligatoria.");
    } else if (!reg_luogo_nascita_residenza.test(provinciaTecnico)) {
        $("#provincia-ordine-tecnico").addClass("is-invalid");
        $("#errore_provincia_ordine_tecnico").addClass("invalid-feedback");
        $("#errore_provincia_ordine_tecnico").text("Provincia/Sezione/Regione di iscrizione non valida.");
    } else {
        $("#provincia-ordine-tecnico").removeClass("is-invalid");
        $("#errore_provincia_ordine_tecnico").removeClass("invalid-feedback");
        $("#errore_provincia_ordine_tecnico").text("");
    }
});

$(document).on("input", "#ordine-tecnico", function () {
    var ordineTecnico = $(this).val();
    if (ordineTecnico.length == 0) {
        $("#ordine-tecnico").addClass("is-invalid");
        $("#errore_ordine_tecnico").addClass("invalid-feedback");
        $("#errore_ordine_tecnico").text("Ordine di appartenenza obbligatorio.");
    } else if (!reg_nome_cognome.test(ordineTecnico)) {
        $("#ordine-tecnico").addClass("is-invalid");
        $("#errore_ordine_tecnico").addClass("invalid-feedback");
        $("#errore_ordine_tecnico").text("Ordine di appartenenza non valido.");
    } else {
        $("#ordine-tecnico").removeClass("is-invalid");
        $("#errore_ordine_tecnico").removeClass("invalid-feedback");
        $("#errore_ordine_tecnico").text("");
    }
});
  
$(document).on("input", "#numero-iscrizione-ordine-tecnico", function () {
    var numeroIscrizioneTecnico = $(this).val();
    if (numeroIscrizioneTecnico.length == 0) {
        $("#numero-iscrizione-ordine-tecnico").addClass("is-invalid");
        $("#errore_numero_iscrizione_ordine_tecnico").addClass("invalid-feedback");
        $("#errore_numero_iscrizione_ordine_tecnico").text("Numero di iscrizione obbligatorio.");
    } 
    /*
    else if (!reg_iscrizione_ordine.test(numeroIscrizioneTecnico)) {
        $("#numero-iscrizione-ordine-tecnico").addClass("is-invalid");
        $("#errore_numero_iscrizione_ordine_tecnico").addClass("invalid-feedback");
        $("#errore_numero_iscrizione_ordine_tecnico").text("Numero di iscrizione non valido. (es. PA1234)");
    } 
    */
    else {
        $("#numero-iscrizione-ordine-tecnico").removeClass("is-invalid");
        $("#errore_numero_iscrizione_ordine_tecnico").removeClass("invalid-feedback");
        $("#errore_numero_iscrizione_ordine_tecnico").text("");
    }
});
/*==== VALIDAZIONI SEZIONE TECNICO COMPETENTE ====*/



// Regole: singoli/associati => SOLO Tecnico Esterno; comuni => entrambi
$(function () {
  const $beneficiari = $("input[name='tipo_beneficiario']");
  const $tecEst = $("input[name='tipo_tecnico'][value='Tecnico Esterno']");
  const $tecInt = $("input[name='tipo_tecnico'][value='Tecnico Interno']");

  function applyBeneficiarioRules() {
    const val = $beneficiari.filter(":checked").val();

    if (val === "singoli" || val === "associati") {
      // blocco l'interno, forzo esterno
      $tecInt.prop({ disabled: true, checked: false });
      $tecEst.prop({ disabled: false, checked: true }).trigger("change");
    } else if (val === "comuni") {
      // entrambi abilitati
      $tecInt.prop("disabled", false);
      $tecEst.prop("disabled", false);

      // riallineo la UI in base al radio attualmente selezionato
      $("input[name='tipo_tecnico']:checked").trigger("change");
    }
  }

  $beneficiari.on("change", applyBeneficiarioRules);
  applyBeneficiarioRules(); // inizializzazione all'apertura pagina
});